/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.regexbridge;

import com.mckoi.database.RegexLibrary;
import com.mckoi.database.TObject;
import com.mckoi.database.Table;
import com.mckoi.util.IntegerVector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class JavaRegex
implements RegexLibrary {
    public boolean regexMatch(String regular_expression, String expression_ops, String value) {
        try {
            int c_flags = 0;
            if (expression_ops != null) {
                if (expression_ops.indexOf(105) != -1) {
                    c_flags += 2;
                }
                if (expression_ops.indexOf(115) != -1) {
                    c_flags += 32;
                }
                if (expression_ops.indexOf(109) != -1) {
                    c_flags += 8;
                }
            }
            Pattern pattern = Pattern.compile(regular_expression, c_flags);
            Matcher matcher = pattern.matcher(value);
            return matcher.matches();
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }

    public IntegerVector regexSearch(Table table, int column, String regular_expression, String expression_ops) {
        Pattern pattern;
        IntegerVector row_list = table.selectAll(column);
        IntegerVector result_list = new IntegerVector();
        try {
            int c_flags = 0;
            if (expression_ops != null) {
                if (expression_ops.indexOf(105) != -1) {
                    c_flags += 2;
                }
                if (expression_ops.indexOf(115) != -1) {
                    c_flags += 32;
                }
                if (expression_ops.indexOf(109) != -1) {
                    c_flags += 8;
                }
            }
            pattern = Pattern.compile(regular_expression, c_flags);
        }
        catch (PatternSyntaxException e) {
            return result_list;
        }
        int size = row_list.size();
        for (int i = 0; i < size; ++i) {
            Object ob;
            String str;
            int row_index = row_list.intAt(i);
            TObject cell = table.getCellContents(column, row_index);
            if (cell.isNull() || !pattern.matcher(str = (ob = cell.getObject()).toString()).matches()) continue;
            result_list.addInt(row_index);
        }
        return result_list;
    }
}

